//
//  Copyright 2011 Justin.tv. All rights reserved.
//

#import "NSIndexPathAdditions.h"

@implementation NSIndexPath (Additions)
+ (NSArray *) indexPathsFromIndex:(NSUInteger) startIndex forCount:(NSUInteger) count inSection:(NSUInteger) section {
	NSMutableArray *indexPaths = [NSMutableArray array];

	for (NSUInteger i = 0; i < count ; i++)
		[indexPaths addObject:[NSIndexPath indexPathForRow:startIndex + i inSection:section]];

	return indexPaths;
}
@end
